*****************************************************************************
* PROGRAM: 30_towns_t4
* PROGRAMMER: Modified by Gina Li at MIT, Oct. 2015
* PURPOSE: Makes Table 4 of Angrist, Lavy (2001) and outputs table into .csv
*****************************************************************************
capture log close
clear all
cd "`directory'"

set more off


log using "Table4.log", replace


use merge3a_public_final, clear

matrix t4 = J(15,6,.)

replace male4= male5 if male4==.

replace male4= male6 if male4==.
replace male4 = 0 if male4==2
 
gen ole4 = (migyear4 > 1951 & migyear4 != . )

replace dadedr4 = . if dadedr4 == 99
replace momedr4 = . if momedr4 == 99
replace famsize4 = . if famsize4 <= 1

gen married4 = mstatus4 == 2
gen age4 = 1994 - dobyear4

 
preserve

keep if relig==0
keep if in94==1 

reg male4 treated

matrix t4[1,1] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[2,1] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[1,2] = _b[_cons]
matrix t4[2,2] = _se[_cons]
matrix t4[1,3] = _b[treated]
matrix t4[2,3] = _se[treated]
. 
reg ole4 treated

matrix t4[3,1] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[4,1] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[3,2] = _b[_cons]
matrix t4[4,2] = _se[_cons]
matrix t4[3,3] = _b[treated]
matrix t4[4,3] = _se[treated]

reg famsize4 treated


matrix t4[5,1] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[6,1] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[5,2] = _b[_cons]
matrix t4[6,2] = _se[_cons]
matrix t4[5,3] = _b[treated]
matrix t4[6,3] = _se[treated]

reg married4 treated


matrix t4[7,1] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[8,1] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[7,2] = _b[_cons]
matrix t4[8,2] = _se[_cons]
matrix t4[7,3] = _b[treated]
matrix t4[8,3] = _se[treated]

reg dadedr4 treated if dadedr4 > 0 & dadedr4 <= 21


matrix t4[9,1] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[10,1] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[9,2] = _b[_cons]
matrix t4[10,2] = _se[_cons]
matrix t4[9,3] = _b[treated]
matrix t4[10,3] = _se[treated]

reg momedr4 treated if momedr4 > 0 & momedr4 <= 21

matrix t4[11,1] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[12,1] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[11,2] = _b[_cons]
matrix t4[12,2] = _se[_cons]
matrix t4[11,3] = _b[treated]
matrix t4[12,3] = _se[treated]

reg age4 treated if age4 <= 12

matrix t4[13,1] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[14,1] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[13,2] = _b[_cons]
matrix t4[14,2] = _se[_cons]
matrix t4[13,3] = _b[treated]
matrix t4[14,3] = _se[treated]

count if treated == 1
 
matrix t4[15,1] = r(N)

count if treated == 0
 
matrix t4[15,2] = r(N)

restore 

preserve

keep if relig==1
keep if in94==1 

reg male4 treated

matrix t4[1,4] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[2,4] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 

matrix t4[1,5] = _b[_cons]
matrix t4[2,5] = _se[_cons]
matrix t4[1,6] = _b[treated]
matrix t4[2,6] = _se[treated]

reg ole4 treated

matrix t4[3,4] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[4,4] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[3,5] = _b[_cons]
matrix t4[4,5] = _se[_cons]
matrix t4[3,6] = _b[treated]
matrix t4[4,6] = _se[treated]

reg famsize4 treated

matrix t4[5,4] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[6,4] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[5,5] = _b[_cons]
matrix t4[6,5] = _se[_cons]
matrix t4[5,6] = _b[treated]
matrix t4[6,6] = _se[treated]

reg married4 treated

matrix t4[7,4] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[8,4] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[7,5] = _b[_cons]
matrix t4[8,5] = _se[_cons]
matrix t4[7,6] = _b[treated]
matrix t4[8,6] = _se[treated]

reg dadedr4 treated if dadedr4 > 0 & dadedr4 <= 21

matrix t4[9,4] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[10,4] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[9,5] = _b[_cons]
matrix t4[10,5] = _se[_cons]
matrix t4[9,6] = _b[treated]
matrix t4[10,6] = _se[treated]

reg momedr4 treated if momedr4 > 0 & momedr4 <= 21

matrix t4[11,4] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[12,4] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[11,5] = _b[_cons]
matrix t4[12,5] = _se[_cons]
matrix t4[11,6] = _b[treated]
matrix t4[12,6] = _se[treated]
 
reg age4 treated if age4 <= 12

matrix t4[13,4] = _b[_cons] + _b[treated]
matrix V = e(V)
matrix t4[14,4] = sqrt(V[2,2] + V[1,1] + 2 * V[2,1]) 
matrix t4[13,5] = _b[_cons]
matrix t4[14,5] = _se[_cons]
matrix t4[13,6] = _b[treated]
matrix t4[14,6] = _se[treated]
 
count if treated == 1
 

matrix t4[15,4] = r(N)

 
count if treated == 0

matrix t4[15,5] = r(N)

restore 

clear

svmat t4

outsheet using "table4_output.csv", comma replace

log close



